local dragon_icons={}
local activeCircles={}
local scheduledEvents={{time=12.65,count=6,delayBetween=0.117},{time=16.40,count=6,delayBetween=0.117},{time=20.15,count=6,delayBetween=0.117},{time=23.90,count=6,delayBetween=0.117},{time=27.65,count=6,delayBetween=0.117},{time=31.40,count=6,delayBetween=0.117},{time=35.15,count=6,delayBetween=0.117},{time=38.90,count=6,delayBetween=0.117},{time=84.13,count=4,delayBetween=0.117},{time=167.98,count=1,delayBetween=0.117},{time=168.21,count=6,delayBetween=0.117}}
local hueShader
local screenWidth=1920
local screenHeight=1080
local availableImages={love.graphics.newImage("dragonicon1.png"),love.graphics.newImage("dragonicon2.png"),love.graphics.newImage("dragonicon3.png"),love.graphics.newImage("dragonicon4.png"),love.graphics.newImage("dragonicon5.png"),love.graphics.newImage("dragonicon6.png"),love.graphics.newImage("dragonicon7.png"),love.graphics.newImage("dragonicon8.png"),love.graphics.newImage("dragonicon9.png")}
local function isPositionValid(newX,newY,size)
if newX-size/2<0 or newX+size/2>screenWidth or newY-size/2<0 or newY+size/2>screenHeight then return false end
for _,circle in ipairs(activeCircles) do
local dx=circle.position.x-newX
local dy=circle.position.y-newY
local distance=math.sqrt(dx*dx+dy*dy)
if distance<size+21 then return false end
end
return true
end
function dragon_icons.load()
math.randomseed(os.time())
hueShader=love.graphics.newShader([[ 
extern float hueShift;
vec4 effect(vec4 color, Image texture, vec2 texture_coords, vec2 screen_coords) {
vec4 pixel = Texel(texture, texture_coords);
float angle = hueShift * 3.14159 / 180.0;
float Y = 0.299 * pixel.r + 0.587 * pixel.g + 0.114 * pixel.b;
float I = 0.596 * pixel.r - 0.275 * pixel.g - 0.321 * pixel.b;
float Q = 0.212 * pixel.r - 0.523 * pixel.g + 0.311 * pixel.b;
float cosA = cos(angle);
float sinA = sin(angle);
float I_new = I * cosA - Q * sinA;
float Q_new = I * sinA + Q * cosA;
float r = Y + 0.956 * I_new + 0.621 * Q_new;
float g = Y - 0.272 * I_new - 0.647 * Q_new;
float b = Y - 1.106 * I_new + 1.703 * Q_new;
return vec4(r, g, b, pixel.a) * color; } ]])
for _,event in ipairs(scheduledEvents) do event.triggered=false end
end
function dragon_icons.update(dt,timePassed)
for _,event in ipairs(scheduledEvents) do
if not event.triggered and timePassed>=event.time then
event.triggered=true
for i=1,event.count do
local size=math.random(150,300)
local position
repeat position={x=math.random(size/2,screenWidth-size/2),y=math.random(size/2,screenHeight-size/2)} until isPositionValid(position.x,position.y,size)
table.insert(activeCircles,{spawnTime=event.time+(i-1)*event.delayBetween,spawned=false,position=position,size=size,colorHue=math.random(0,360),opacity=1,fadeOutDuration=1.0,fadeOutTimer=0,image=availableImages[math.random(#availableImages)],flipped=math.random()<0.5})
end end end
for _,circle in ipairs(activeCircles) do
if not circle.spawned and timePassed>=circle.spawnTime then circle.spawned=true end
if circle.spawned and circle.opacity>0 then
circle.fadeOutTimer=circle.fadeOutTimer+dt
local fadeProgress=circle.fadeOutTimer/circle.fadeOutDuration
if fadeProgress>1 then fadeProgress=1 end
circle.opacity=0.8*(1-fadeProgress)
end end
for i=#activeCircles,1,-1 do
local circle=activeCircles[i]
if circle.spawned and circle.opacity<=0 then table.remove(activeCircles,i) end
end end
function dragon_icons.draw()
for _,circle in ipairs(activeCircles) do
if circle.spawned then
love.graphics.push()
love.graphics.translate(circle.position.x,circle.position.y)
love.graphics.scale((circle.size/circle.image:getWidth())*(circle.flipped and -1 or 1),circle.size/circle.image:getHeight())
love.graphics.setShader(hueShader)
hueShader:send("hueShift",circle.colorHue)
love.graphics.setColor(1,1,1,circle.opacity)
love.graphics.draw(circle.image,-circle.image:getWidth()/2,-circle.image:getHeight()/2)
love.graphics.setShader()
love.graphics.pop()
end end
love.graphics.setColor(1,1,1,1)
end
return dragon_icons
